<?php
/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

!defined('DL_Root') && exit ( 'Access Denied!' );

class File extends DCacheDriver{

	private $dir;

	private $path;
	
	public function __construct()
	{
		$this->dir = APP_PATH . 'Cache' . DS . 'Data' . DS . date('Ym'). DS;
		$this->path = APP_PATH . 'Cache' . DS . 'Data';
		is_dir($this->dir) or @mkdir($this->dir);
		is_writable($this->dir) or DuoLam::e('缓存目录不可写：'.$this->dir.'请手动修改!');
		return $this;
	}
	
	public function set($k,$v,$time=600,$all=false)
	{
		if($all)
		{
			$k .='_all';
		}
		$file = $this->dir . md5($k) . '.DuoLamCache';
		file_put_contents($file,serialize($v),LOCK_EX);
		@touch($file, time() + $time);
	}
	
	public function get($k,$all=false)
	{
		if($all) $k.='_all';
		$file = $this->dir . md5($k) . '.DuoLamCache';
		if(is_file($file))
		{
			if(time() <= filemtime($file))
			{
				return unserialize(file_get_contents($file));
			}
			else
			{
				@unlink($file);
				return false;
			}
		}
		else
		{
			return false;
		}
	}
	
	public function del($k)
	{
		$file = $this->dir . md5($k) . '.cache';
		if($this->$k)
		{
			@unlink($file);
			return true;
		}
		else
		{
			return false;
		}
	}
	
	public function delAll($path='')
	{
		$path = empty($path) ? $this->path : $path;
		$rs = opendir($path);
		while($file = readdir($rs))
		{
			if($file == '.' or $file =='..') continue;
			if(is_dir($this->path . DS . $file))
			{
				$this->delAll($path . DS .$file);
			}
			else 
			{
				@unlink($path . DS .$file);
				
			}
			clearstatcache();
		}
		return true;
	}
	
	public function is($k)
	{
		return (is_file($this->dir . md5($k) . '.DuoLamCache') === NULL ? false : true);
	}
}
?>